<?php
class Cafetiere {

	// Attributs privés
    private $capaciteMax;
    private $quantiteEau;
    
	// Constructeurs
    public function __construct(float $capaciteMax = 1.0)
	{
        $this->capaciteMax = $capaciteMax;
        if($this->capaciteMax <= 0)
            $this->capaciteMax = 1.0;
        $this->quantiteEau = 0;
    }
    
	// Getters / Setters
    public function getCapaciteMax() : float
	{
        return $this->capaciteMax;
    }
    
    public function getQuantiteEau() : float
	{
        return $this->quantiteEau;
    }
    
	// Les méthodes    
    public function remplir(float $quantiteEau) : void
	{
        $this->quantiteEau += $quantiteEau;
        if($this->quantiteEau > $this->capaciteMax)
            $this->quantiteEau = $this->capaciteMax;
    }
	
    public function prendreCafe() : bool {
        $resultat = false;
        if($this->quantiteEau >= 0.2) {
            $this->quantiteEau -= 0.2;
            $resultat = true;
        }
        return $resultat;            
    }
    
    public function afficher() : void {
        echo "Cafetiere : {$this->quantiteEau} L / {$this->capaciteMax} L";
    }    
}